/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.managed.HwmcaObjectProperties;
import com.ibm.hwmca.fw.managed.HwmcaParentObjectProperties;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.UIInfo;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class UIHwmcaObject
implements Serializable,
HwmcaParentObjectProperties,
HwmcaObjectProperties {
    private ObjectId objectId;
    private UIInfo uiInfo;
    private ArrayList children;
    private transient Object childrenLock;
    protected transient PropertyChangeSupport propertyChangeSupport;

    public UIHwmcaObject(ObjectId objectId, UIInfo uiInfo) {
        this.objectId = objectId;
        this.uiInfo = uiInfo;
        if (this.uiInfo == null) {
            System.out.println("UIInfo is null for ObjectId " + objectId);
        }
        if (this.objectId == null) {
            System.out.println("objectId is null");
        }
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public UIInfo getUIInfo() {
        return this.uiInfo;
    }

    public List getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setUIInfo(UIInfo uiInfo) {
        UIInfo oldValue = this.uiInfo;
        this.uiInfo = uiInfo;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("UIInfo", oldValue, uiInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren(ObjectId[] objectIds) {
        if (this.childrenLock == null) {
            this.childrenLock = new Object();
        }
        Object object = this.childrenLock;
        synchronized (object) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            int i = 0;
            while (i < objectIds.length) {
                this.children.add(objectIds[i]);
                ++i;
            }
        }
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("Children", null, objectIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren(ObjectId[] objectIds) {
        if (this.children != null) {
            if (this.childrenLock == null) {
                this.childrenLock = new Object();
            }
            Object object = this.childrenLock;
            synchronized (object) {
                int i = 0;
                while (i < objectIds.length) {
                    this.children.remove(objectIds[i]);
                    ++i;
                }
            }
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.firePropertyChange("Children", objectIds, null);
            }
        }
    }

    public String getText() {
        return this.getUIInfo().getTitle();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }
}

